--START 999 - SYS7.4.0.2 - HA Customizations.sql

USE [LINKSOFT]
GO
UPDATE LT_SYS_Customizations SET Enabled = 1 WHERE ModuleID = 'SYS' AND Process = 'Post Upgrade' AND Description = 'Post upgrade customizations for Housing Authority'
UPDATE LBS_CONFIG SET value_str = 'CUSTOM' WHERE flag = 'FMIS.GL.SYSTEM' AND module_id = 'PAY'
UPDATE LBS_CONFIG SET value_str = 'LBS_GL_Integration_CUSTOM_HousingAuthority' WHERE flag = 'FMIS.GL.CUSTOM.PROCEDURE' AND module_id = 'PAY'
GO
--Apply customizations
EXEC [dbo].[LT_SYS_Customizations_PROCESS]
	 @ModuleID = 'SYS'
	,@Process = 'Post Upgrade'
GO

-- END OF SCR ====================================================================================
Declare @sUser VARCHAR(255) 
       ,@sMachine VARCHAR(255) 
       ,@sMsg VARCHAR(MAX) 
       ,@sModule VARCHAR(255) 

SELECT @sUser = SUSER_SNAME()
	  ,@sMachine = HOST_NAME()
	  ,@sMsg = '999 - SYS7.4.0.2 - HA Customizations'
	  ,@sModule = 'Link SYS'

Exec LBS_LogMessage @sUser = @sUser ,@sModule = @sModule ,@sMsg = @sMsg ,@sStatus = 'Upgrade' ,@sMachine = @sMachine
PRINT @sMsg

--END 999 - SYS7.4.0.2 - HA Customizations.sql

GO
